﻿using System.Collections;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using Verse;


namespace RimWorld{
public class IncidentWorker_CropBlight : IncidentWorker
{
	const float MaxDaysToGrown = 16;


	public override bool TryExecute( IncidentParms parms )
	{
		var map = (Map)parms.target;

        var plants = map.listerThings.ThingsInGroup( ThingRequestGroup.Plant );

		bool cropFound = false;
		for( int i=plants.Count-1; i>=0; i-- )
		{
			var plant = (Plant)plants[i];

			if( map.Biome.CommonalityOfPlant(plant.def) != 0 )
				continue;

			if( plant.def.plant.growDays > MaxDaysToGrown )
				continue;

            if (plant.LifeStage == PlantLifeStage.Growing || plant.LifeStage == PlantLifeStage.Mature)
            {
				plant.CropBlighted();

                cropFound = true;
            }
		}

        if ( !cropFound )
            return false;
		else
		{
			Find.LetterStack.ReceiveLetter("LetterLabelCropBlight".Translate(), "CropBlight".Translate(), LetterType.BadNonUrgent);
			return true;
		}
	}
}

}